<?php 
namespace App\Controllers;
use App\Models\UserModel;
class Users extends BaseController
{
	
	/*
	public function index()
	{
		$data = [];
		$data = ['data' => ''];
		helper(['form']);
		if ($this->request->getMethod() == 'post') {
			$rules = [
				'username' => 'required|min_length[3]|max_length[20]',
				'password' => 'required|min_length[8]|max_length[255]|validateUser[username,password]',
			];
			$errors = [
				'password' => [
					'validateUser' => 'Username or Password don\'t match'
				]
			];
			if (! $this->validate($rules, $errors)) {
				$data['validation'] = $this->validator;
			}else{
				$model = new UserModel();
				$user = $model->where('email', $this->request->getVar('email'))->first();
				$this->setUserSession($user);
				return redirect()->to('dashboard');
			}
		}
		return view('user/login', $data);
	}
	*/
	
	private function setUserSession($user){
		$data = [
			'id' => $user['id'],
			'companyname' => $user['companyname'],
			'username' => $user['email'],
			'firstname' => $user['firstname'],
			'lastname' => $user['lastname'],
			'email' => $user['email'],
			'buyer' => $user['buyer'],
			'seller' => $user['seller'],
			'isLoggedIn' => true,
		];
		session()->set($data);
		return true;
	}
	
	
	
	public function login()
	{
		$data = [];
		$data = ['data' => ''];
		helper(['form']);
		if ($this->request->getMethod() == 'POST') {
			$rules = [
				'email' => 'required|min_length[3]|max_length[100]',
				'password' => 'required|min_length[8]|max_length[255]|validateUser[username,password]',
			];
			$errors = [
				'password' => [
					'validateUser' => 'Email or Password don\'t match'
				]
			];
			if (! $this->validate($rules, $errors)) {
				$data['validation'] = $this->validator;
			}else{
				$model = new UserModel();
				$user = $model->where('email', $this->request->getVar('email'))->first();
				$this->setUserSession($user);
				return redirect()->to('dashboard');
			}
		}
		return view('user/login', $data);
	}
	
	public function register(){
		$libpath=realpath(dirname(__DIR__) . '/..');
		include_once $libpath.'/send_smtp.php';
		//sendMyMsg('edi.hermann@lemonbyte.ro','edi.hermann@lemonbyte.ro','New registration in cars@zadio.bg','zzzzzzzzzz');
				
		$data = [];
		helper(['form']);
		
		if ($this->request->getMethod() == 'POST') {
			
			$rules = [
				'companyname' => 'required|min_length[3]|max_length[50]',
				'vatnumber' => 'required|min_length[1]|max_length[50]',
				'country' => 'required|min_length[1]|max_length[50]',
				'district' => 'required|min_length[1]|max_length[50]',
				'city' => 'required|min_length[1]|max_length[50]',
				'address' => 'required|min_length[1]|max_length[200]',
				'firstname' => 'required|min_length[1]|max_length[20]',
				'lastname' => 'required|min_length[1]|max_length[20]',
				'email' => 'required|min_length[6]|max_length[50]|valid_email|is_unique[users.email]',
				'password' => 'required|min_length[8]|max_length[255]',
				'password_confirm' => 'matches[password]',
				
			];

			if (! $this->validate($rules)) {
				$data['validation'] = $this->validator;
			}else{
				$model = new UserModel();
				if($this->request->getVar('buyer'))
					$buyer=1;
				else
					$buyer=0;
				
				if($this->request->getVar('seller'))
					$seller=1;
				else
					$seller=0;
				
				
				$newData = [
					
					'companyname' => $this->request->getVar('companyname'),
					'vatnumber' => $this->request->getVar('vatnumber'),
					'country' => $this->request->getVar('country'),
					'district' => $this->request->getVar('district'),
					'city' => $this->request->getVar('city'),
					'address' => $this->request->getVar('address'),
					'firstname' => $this->request->getVar('firstname'),
					'lastname' => $this->request->getVar('lastname'),
					'email' => $this->request->getVar('email'),
					'phone' => $this->request->getVar('phone'),
					'password' => $this->request->getVar('password'),
					'buyer' => $buyer,
					'seller' => $seller,
				];
				$model->save($newData);
				$session = session();
				$session->setFlashdata('success', 'Successful Registration');
				
				$msg='Company:'.$this->request->getVar('companyname').'<br>';
				$msg.='Email:'.$this->request->getVar('email').'<br>';
				$msg.='Phone:'.$this->request->getVar('phone').'<br>';
				sendMyMsg('cars@zadio.bg','cars@zadio.bg','New registration in cars@zadio.bg',$msg);
				return redirect()->to('/users/confirmreg');

			}
		}
		return view('user/register', $data);
	}
	
	public function confirmreg()
	{
		$data = [];
		$data = ['data' => ''];
		
		return view('user/confirmreg', $data);
	}
	
	
	public function profile(){
		$data = [];
		$data = ['data' => ''];
		helper(['form']);
		$model = new UserModel();
		if ($this->request->getMethod() == 'POST') {
			$rules = [
				'username' => 'required|min_length[4]|max_length[20]',
				'realname' => 'required|min_length[3]|max_length[20]',
				'firstname' => 'required|min_length[1]|max_length[20]',
				'lastname' => 'required|min_length[1]|max_length[20]',
				];

			if($this->request->getPost('password') != ''){
				$rules['password'] = 'required|min_length[8]|max_length[255]';
				$rules['password_confirm'] = 'matches[password]';
			}
			if (! $this->validate($rules)) {
				$data['validation'] = $this->validator;
			}else{
				$newData = [
					'id' => session()->get('id'),
					'username' => $this->request->getPost('username'),
					'realname' => $this->request->getPost('realname'),
					'firstname' => $this->request->getPost('firstname'),
					'lastname' => $this->request->getPost('lastname'),
					];
					if($this->request->getPost('password') != ''){
						$newData['password'] = $this->request->getPost('password');
					}
				$model->save($newData);
				session()->setFlashdata('success', 'Successfuly Updated');
				return redirect()->to('/profile');
			}
		}
		$data['user'] = $model->where('id', session()->get('id'))->first();
		
		return view('user/profile', $data);
	}
	public function logout(){
		session()->destroy();
		return redirect()->to('/');
	}
}
