<?php
namespace App\Models;
use CodeIgniter\Model;
Class CarsModel extends Model {
    protected $db;

	 public function __construct()
    {
        $this->db = db_connect();

        
    }
	
	public function get_aprroved_cars() {
        $query = $this->db->query("SELECT * FROM cars where status=3 order by id desc");
        return $query->getResult('array');
    }
	
	public function filter_aprroved_cars($filter) {
		
		$searchstr="";
		if (isset($filter['brand']) && $filter['brand'])
		{
			$searchstr=" and brand='".$filter['brand']."'";
		}
		if(isset($filter['model']) && $filter['model'])
		{
			$searchstr=" and (model_dec='".$filter['model']."' or model='".$filter['model']."') ";
		}

		if(isset($filter['fuel']) && $filter['fuel'])
		{
			$searchstr .=" and fuel='".$filter['fuel']."'";
		}
		
		if(isset($filter['searchstr']) && $filter['searchstr'])
		{
			$srcstr="%".strtolower($filter['searchstr'])."%";
			$searchstr=" and ( LOWER(brand) like '".$srcstr."'".
					   " or LOWER(model) like '".$srcstr."'".
					   " or LOWER(model_dec) like '".$srcstr."'".
					   " or LOWER(code) like '".$srcstr."'".
					   " or LOWER(price_bgn) like '".$srcstr."'".
					   " or LOWER(body_type) like '".$srcstr."'".
					   " or LOWER(cubic_capacity) like '".$srcstr."'".
					   " or LOWER(engine_power_hp) like '".$srcstr."'".
					   " or LOWER(emission_standard) like '".$srcstr."'".
					   " or LOWER(date_manufacture) like '".$srcstr."'".
					   " or LOWER(gear_box) like '".$srcstr."'".
					   " or LOWER(drivetrain) like '".$srcstr."'".
					   " or LOWER(km) like '".$srcstr."'".
					   " or LOWER(vin) like '".$srcstr."'".
					   " or LOWER(technical_status) like '".$srcstr."'".
					   " or LOWER(country_of_origin) like '".$srcstr."'".
					   " or LOWER(notes) like '".$srcstr."'".
					   " or LOWER(fuel) like '".$srcstr."'".
					   " or LOWER(additionals) like '".$srcstr."')";
					   
					   
		}
		
		
			
        $query = $this->db->query("SELECT * FROM cars where status=3  ".$searchstr." order by id desc");
        return $query->getResult('array');
    }

	public function get_aprroved_brands() {
        $query = $this->db->query("SELECT distinct brand as brand_name FROM cars where status=3 order by brand");
        return $query->getResult('array');
    }

	public function get_aprroved_models() {
        $query = $this->db->query("SELECT distinct model FROM cars where status=3 order by model");
        return $query->getResult('array');
    }

	public function get_all_cars() {
        $query = $this->db->query("SELECT * FROM cars");
        return $query->getResult('array');
    }

	public function get_all_fuels(){
		$query = $this->db->query("SELECT distinct fuel FROM cars where status=3");
		return $query->getResult('array');
	}
	
	 public function get_approved_by_code($code) {
        $query = $this->db->query("SELECT * FROM cars where code='$code' and status=3");
        $arr=$query->getResult('array');
		if(count($arr))
			
		return $arr[0];
    }
	
    public function get_all($usr) {
        $query = $this->db->query("SELECT * FROM cars where client_id=$usr");
        return $query->getResult('array');
    }
    
	public function save_data($insert_array)
	{
		$updt_str = '';
		$insr_str='INSERT INTO cars (';
		$insr_val='';
		
		foreach ($insert_array as $k => $v)
		{
			$updt_str = $updt_str.' '.$k.' = \''.addslashes($v).'\',';
			$insr_str = $insr_str.' '.$k.',';
			$insr_val = $insr_val.' \''.addslashes($v).'\',';
		}
		$updt_str = substr_replace($updt_str,"", -1);
		$insr_str =  substr_replace($insr_str,"", -1).')';
		$insr_val = ' VALUES (' .substr_replace($insr_val,"", -1).')';
		$sqlstr=$insr_str . $insr_val. ' ON DUPLICATE KEY UPDATE '.$updt_str;
		//var_dump($sqlstr);exit;
		
		$this->db->query($insr_str . $insr_val. ' ON DUPLICATE KEY UPDATE '.$updt_str);
	}	
   
  
    public function get_by_id($id,$usr) {
        $query = $this->db->query("SELECT * FROM cars where id=$id and client_id=$usr");
        return $query->getResult('array');
    }
	
	 public function get_by_code($code,$usr) {
        $query = $this->db->query("SELECT * FROM cars where code='$code' and client_id=$usr");
        return $query->getResult('array');
    }
	
	public function get_preview($code) {
        $query = $this->db->query("SELECT * FROM cars where code='$code'");
        $res=$query->getResult('array');
		if(count($res))
			return $res[0];
    }


	 public function get_imgs($code) {
        $query = $this->db->query("SELECT * FROM `car_images` where car_code='$code' order by `sort`");
        return $query->getResult('array');
    }


	public function get_brands() {
        $query = $this->db->query("SELECT distinct id, brand_name FROM car_brand  where active=1 order by brand_name");
        return $query->getResult('array');
    }
	

	public function get_client_brands($usr) {
        $query = $this->db->query("SELECT distinct brand as brand_name FROM cars where client_id=$usr order by brand_name" );
        return $query->getResult('array');
    }
	
	
	public function get_country() {
        $query = $this->db->query("SELECT distinct id, country_name FROM country order by country_name");
        return $query->getResult('array');
    }
	
	public function get_car_status() {
        $query = $this->db->query("SELECT distinct id, status_name FROM car_status where active=1 order by status_name ");
        return $query->getResult('array');
    }
	
	
	
    public function set_values($id = 1) {
        $data = array(
            'quantity_defect' => $this->input->post('quantity_defect')
        );
		
        if ($id !=0) {        
           $obs=$this->input->post('obs');
			$quantity_defect=$this->input->post('quantity_defect');
			
			$sqlstr="update cars set quantity_defect=quantity_defect+".$quantity_defect." where id=" . $id;
			$this->db->query($sqlstr);
			
			$sqlstr="insert into defect_log(product_id,quantity_defect,obs) values(".$id.",".$quantity_defect.",'".$obs."')";
			return $this->db->query($sqlstr);
			
		
        } 
    }
	
	public function remove($code,$usr) {
        $query = $this->db->query("SELECT * FROM cars where code='$code' and client_id=$usr");
		$res=$query->getResult('array');
        if(count($res))
		{
		
			 $sqlstr = "DELETE FROM cars where code='$code'";
			 $this->db->query($sqlstr);
			 
			 $sqlstr ="DELETE FROM car_images where car_code='$code'";
			 $this->db->query($sqlstr);
			 
			 return 1;
			 
		
		}
		else
			return 0;
	
    }

	// status can take the following values
	// 0 - Cars published all time
	// 1 - Cars published now 
	// 2 - Cars waiting publishing 
	// 3 - Cars in transaction 
	// 4 - Cars to deliver to Zadio 
	// 5 - Cars to receive payment 
	// 6 - Cars sold 
	public function get_cars_count_seller($usr, $status){
		switch($status){
			case 0:
				$query = $this->db->query("SELECT count(*) as cnt FROM cars where client_id=$usr and status in(3,11,12)");
				break;
			case 1:
				$query = $this->db->query("SELECT count(*) as cnt FROM cars where client_id=$usr and status=3");
				break;
			case 2:
				$query = $this->db->query("SELECT count(*) as cnt FROM cars where client_id=$usr and status=1");
				break;
			case 3:
				$query = $this->db->query("SELECT count(*) as cnt FROM cars where client_id=$usr and status=11");
				break;
			case 4:
				$query = $this->db->query("SELECT COUNT(DISTINCT c.code) AS cnt
				FROM cars c
				JOIN transaction t ON c.code = t.car_code
				WHERE c.client_id = $usr
				AND t.trans_step = 6;");
				break;
			case 5:
				$query = $this->db->query("SELECT COUNT(DISTINCT c.code) AS cnt
				FROM cars c
				JOIN transaction t ON c.code = t.car_code
				WHERE c.client_id = $usr
				AND t.trans_step = 13;");
				break;
			case 6:
				$query = $this->db->query("SELECT count(*) as cnt FROM cars where client_id=$usr and status=12");
				break;
			default:
				return [];
		}
		return $query->getResult('array')[0];
	}

	// status can take the following values

	// Cars sections need the following data:
	// 0- Favorite cars 
	// 1 - Saved searches 
	// 2 - Cars in transaction
	// 3 - Cars I paid
	// 4 - Cars to pickup from Zadio
	// 5 - Cars to deliver to  Client
	// 6 - Total Cars I bought
	public function get_cars_count_buyer($usr, $status){
		switch($status){
			case 0:
				// TODO after implementing favorite cars
				break;
			case 1:
				// TODO after implementing saved searches
				break;
			case 2:
				// trans_step < 19 - Cars in transaction
				$query = $this->db->query("SELECT COUNT(DISTINCT c.code) AS cnt
				FROM cars c
				JOIN transaction t ON c.code = t.car_code
				WHERE t.buyer_id = $usr
				AND t.trans_step < 19;");
				break;
			case 3:
				// trans_step = 19 - Cars I paid
				$query = $this->db->query("SELECT COUNT(DISTINCT c.code) AS cnt
				FROM cars c
				JOIN transaction t ON c.code = t.car_code
				WHERE t.buyer_id = $usr
				AND t.trans_step = 5;");
				break;
			case 4:
				// trans_step = 20 - Cars to pickup from Zadio
				$query = $this->db->query("SELECT COUNT(DISTINCT c.code) AS cnt
				FROM cars c
				JOIN transaction t ON c.code = t.car_code
				WHERE t.buyer_id = $usr
				AND t.trans_step = 16;");
				break;
			case 5:
				// trans_step = 21 - Cars to deliver to  Client
				$query = $this->db->query("SELECT COUNT(DISTINCT c.code) AS cnt
				FROM cars c
				JOIN transaction t ON c.code = t.car_code
				WHERE t.buyer_id = $usr
				AND t.trans_step = 18;");
				break;
			case 6:
				// trans_step = 22 - Total Cars I bought
				$query = $this->db->query("SELECT COUNT(DISTINCT c.code) AS cnt
				FROM cars c
				JOIN transaction t ON c.code = t.car_code
				WHERE t.buyer_id = $usr
				AND t.trans_step = 19;");
				break;
			default:
				return [];

		}

		return $query->getResult('array')[0];
		

	}

	//Returns the number of cars in status 3 - published
	public function get_available_cars_count(){

		$query = $this->db->query("SELECT count(*) as cnt FROM cars where status=3");

		return $query->getResult('array')[0];
	}
	
	public function get_car_count_by_status($usr){
		$query = $this->db->query("SELECT status, count(*) as cnt FROM cars where client_id=$usr group by status");
		return $query->getResult('array');
	}
    
    public function search(){
        $this->db->or_like('description', $this->input->post('search'), 'both');
        $this->db->or_like('barcode', $this->input->post('search'), 'both');
        $this->db->or_like('customer', $this->input->post('search'), 'both');
		$this->db->where('quantity_defect>0');
        $query = $this->db->get('products');
        return $query->getResult('array');
    }
    
    
    
}
