<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\MessageModel;
use App\Models\CarsModel;
use App\Models\TransactionModel;

class DashboardController extends BaseController
{

    protected $messageModel;
    protected $transactionModel;
    protected $carsModel;


    public function __construct()
    {
        $this->messageModel = new MessageModel();
        $this->transactionModel = new TransactionModel();
        $this->carsModel = new CarsModel();
    }


	public function index()
	{
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
        $data = ['data' => ''];

        //Check the user type and return the dashboard
        if (session()->get('buyer')){

            // Cars sections need the following data:
            // Cars available now 23
            // Favorite cars 15
            // Saved searches 3
            // Cars in transaction 15
            // Cars I paid 15
            // Cars to pickup from Zadio 2
            // Cars to deliver to  Client 3
            // Total Cars I bought 30
            
            $data['cars_available_now'] = $this->carsModel->get_available_cars_count();
            //$data['favorite_cars'] = $this->carsModel->get_cars_count_buyer($usr,1);
            //$data['saved_searches'] = $this->carsModel->get_cars_count_buyer($usr,2);
            $data['cars_in_transaction'] = $this->carsModel->get_cars_count_buyer($usr,3);
            $data['cars_i_paid'] = $this->carsModel->get_cars_count_buyer($usr,4);
            $data['cars_to_pickup_from_zadio'] = $this->carsModel->get_cars_count_buyer($usr,5);
            $data['cars_to_deliver_to_client'] = $this->carsModel->get_cars_count_buyer($usr,6);
            $data['total_cars_i_bought'] = $this->carsModel->get_cars_count_buyer($usr,7);


            $data['active_transactions'] = $this->transactionModel->get_active_transactions_count_buyer($usr);
            $data['concluded_transactions'] = $this->transactionModel->get_concluded_transactions_count_buyer($usr);

            $data['messages_from_zadio'] = $this->messageModel->get_messages_count_from_zadio($usr);

            return view('dashboard/dashboard_buyer',$data);
        }
        else 
        if(session()->get('seller')){
            

            // Cars sections need the following data:
            // Cars published all time 106
            // Cars published now 23
            // Cars waiting publishing 5
            // Cars in transaction 7
            // Cars to deliver to Zadio 3
            // Cars to receive payment 3
            // Cars sold 55

            $data['cars_published_all_time'] = $this->carsModel->get_cars_count_seller($usr,0);
            $data['cars_published_now'] = $this->carsModel->get_cars_count_seller($usr,1);
            $data['cars_waiting_publishing'] = $this->carsModel->get_cars_count_seller($usr,2);
            $data['cars_in_transaction'] = $this->carsModel->get_cars_count_seller($usr,3);
            $data['cars_to_deliver_to_zadio'] = $this->carsModel->get_cars_count_seller($usr,4);
            $data['cars_to_receive_payment'] = $this->carsModel->get_cars_count_seller($usr,5);
            $data['cars_sold'] = $this->carsModel->get_cars_count_seller($usr,6);

            $data['active_transactions'] = $this->transactionModel->get_active_transactions_count_seller($usr);
            $data['concluded_transactions'] = $this->transactionModel->get_concluded_transactions_count_seller($usr);

            $data['messages_from_zadio'] = $this->messageModel->get_messages_count_from_zadio($usr);

            return view('dashboard/dashboard_seller',$data);
        }


		return view('dashboard/index', $data);	   
        
	}

    public function get_summaries(){
        if ($this->request->isAJAX() && session()->get('id') > 0) {

            $usr = session()->get('id');

            // Start loading data for the dashboard

            /*
            01.01.2025 car statuses are as follows:
                                    case 0: $sta="Draft";break;
                                    case 1: $sta="Pending approval";break;
                                    case 3: $sta="Published";break;
                                    case 11: $sta="In transaction";break;
                                    case 12: $sta="Sold";break;
                                    case -1: $sta="Publish rejected";break;

            01.01.2025 transaction statuses are as follows:
                                    case 19: Finalized; break;
                                    default: In Progress; break;

            */

            if(session()->get('buyer'))
                $transactions_count_by_status = $this->transactionModel->get_transaction_count_by_status_buyer($usr);
            if(session()->get('seller'))
                $transactions_count_by_status = $this->transactionModel->get_transaction_count_by_status_seller($usr);


            $cars_count_by_status = $this->carsModel->get_car_count_by_status($usr);

            $unread_messages_count = $this->messageModel->get_unread_messages_count($usr);

            return $this->response->setJSON([
                'cars_count_by_status' => $cars_count_by_status,
                'transactions_count_by_status' => $transactions_count_by_status,
                'unread_messages_count' => $unread_messages_count,
            ]);
        }
        return $this->response->setStatusCode(400, 'Bad Request');
    }
	public function search()
	{
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		
		$data = ['data' => ''];
		$po = new PoModel();
		$co = new PoProductsModel();
		$ar = new ProductsModel();
		$pa = new PalletsModel();
		$zo = new ZonesModel();
		$in = new InventoryModel();
		$tr = new TransfersModel();
		$or = new OrderModel();
		if (isset($_POST['q'])){
	     $q = $_POST['q'];
	     $r = $pa->find($q);
	     if (isset($r)){
          $data['found'] = 'pallet';
		  $data['content'] = $r;
	     }
	     else {
          $p = $ar->select('id')->where('barcode',$q)->findAll();
          if (count($p) > 0){
	       $data['found'] = 'produs(e)';
 		   $data['content'] = $p;
 	      }
 	      else {
           $z = $zo->where('barcode',$q)->findAll();
           if (count($z) > 0){
	        $data['found'] = 'zone';
 		    $data['content'] = $z;
 	       }
 	       else {
	        $data['found'] = '';
  		    $data['content'] = [];
 	       }
 	      }
	     }
	    }
        $data['po_nr'] = $po->select('id')->countAllResults();
        $data['po_ct'] = $po->where('pallets_in', 0)->countAllResults();
        $data['po_nw'] = $po->where('po_status', 'Noua')->countAllResults();
        $data['pa_nr'] = $co->select('pallet_id')->distinct('pallet_id')->countAllResults();
        $data['ba_nr'] = $co->select('product_code')->distinct('product_code')->countAllResults();
        $data['ia_nr'] = $ar->select('id')->distinct('id')->countAllResults();
        $data['ip_nr'] = $pa->select('id')->distinct('id')->countAllResults();
        $data['iz_nr'] = $pa->select('zone_id')->distinct('zone_id')->countAllResults();
        $data['tp_nr'] = $tr->select('pallet_id')->distinct('pallet_id')->countAllResults();
        $data['ta_nr'] = $tr->select('zone_id')->distinct('zone_id')->countAllResults();
        $data['or_nr'] = $or->select('id')->where("order_status='Noua' AND order_date>now() - interval 30 day")->countAllResults();
        $data['oi_nr'] = $or->select('id')->where("order_date >now() - interval 30 day AND shiping_date	 is not null")->distinct('id')->countAllResults();
		$us = session()->get('id');
        return view('dashboard/result', $data);	   
	}
    public function search1()
    {
        helper(['form', 'url']);
        $data = [];
        $po = new PoModel();
        $query = $po->like('customer', $this->request->getVar('q'))
         ->select('customer as id, customer as text')
         ->limit(10)->get();
        $data = $query->getResult();
        $data['data'] = $po->select('customer as id', 'customer as text')->findAll();
		echo json_encode($data);
    }
    public function list()
    {
        if ($this->request->getMethod() == 'post') {
            $users = new UserModel();
            $users = $users->havingLike('firstname', $this->request->getPost('search'))->get()->getResult();
            foreach ($users as $user) {
                $response[] = array("value" => $user->id, "label" => $user->firstname);
            }
            echo json_encode($response);
        }
    } 
    public function search2()
    {
        helper(['form', 'url']);
        $data = [];
        $db      = \Config\Database::connect();
        $builder = $db->table('users');   
        $query = $builder->like('realname', $this->request->getVar('q'))
                    ->select('id, realname as text')
                    ->limit(10)->get();
        $data = $query->getResult();
        
		echo json_encode($data);
    }
}
