<?php

const VATBG="0.20";
const BGNEUR="0.5154";


$vatbg=0.20;
$bgneur=0.5154;
$roneur=0.20;

load_commissions();

function front_url()
{
	return "https://cars.zadio.bg/";
}

function formatPhone($number)
{
	if(strlen($number) >= 10) {
	  if(substr($number,0,1)=='+')
	  {
		  $prefix=substr($number,0,4);
		  $number=substr($number,4);
		  $parts = str_split($number, 3);
		  $number = $prefix.' '. $parts[0] .' '. $parts[1] .' '. $parts[2];
	  }
	}
	return $number;
}

function formatCode($number)
{
	  $parts = str_split($number, 3);
	  $number = $parts[0] .'.'. $parts[1] .'.'. $parts[2].'.'. $parts[3];
	  return $number;
}



function load_commissions()
{
	//var_dump(session()->get('commission_abs'));exit;
	
	if(session()->get('commission_abs')==NULL)
	{
		$sqlstr="select  `commission_abs`, `commission_percent`, `commission_min` from company_details limit 1";
		$db = db_connect();
		$query = $db->query($sqlstr);
		$res= $query->getResult('array');
		foreach($res as $row)
		{
			session()->set($row);
			//var_dump(session()->get());exit;
			return;
		}
	}
	
}

//SELLER price
///////////////////////////////////////////////////////////////
function bgnNet($priceBGN) //fara tva
{
	return round($priceBGN);
}

function bgnBrut($priceBGN) //cu tva
{
	return round($priceBGN*(1+VATBG));
}

function seller_bgnNet($priceBGN)
{
	return $priceBGN;
}

function seller_bgnBrut($priceBGN)
{
	return round($priceBGN*(1+VATBG));
}

function seller_eurNet($priceBGN) //fara tva
{
	return round($priceBGN*BGNEUR);
}

function seller_eurBrut($priceBGN) //fara tva
{
	return round($priceBGN*BGNEUR*(1+VATBG));
	
}

//Buyer price
///////////////////////////////////////////////////////////////


function buyer_eurNet($priceBGN) //fara tva
{
	$session = session();
	$commission_abs=$session->get('commission_abs');
	$commission_percent=$session->get('commission_percent');
	$commission_min=$session->get('commission_min');
	
	if($commission_abs>0)
		return round(($priceBGN+$commission_abs)*BGNEUR,2);
	else
	{
		if($priceBGN*$commission_percent > $commission_min)
			return round($priceBGN*BGNEUR*(1+$commission_percent),2);
		else
			return round(($priceBGN+$commission_min)*BGNEUR,2);
	}
}

function buyer_eurBrut($priceBGN) //fara tva
{
	return round(buyer_eurNet($priceBGN)*(1+VATBG),2);
}



//Client
/////////////////////////////////////////////////////////////////////////










?>