<?= $this->extend('rs/template-user', $data); ?>
<?= $this->section('content'); ?>
<?php $this->include('rs/utils.php')?> 
<?php include ('../public/resizeimgs.php')?> 
<script src="https://code.jquery.com/jquery-3.6.0.js"></script>
<script type="text/javascript">document.getElementById("cars").classList.add("active");</script> 
<style>
	.icon-btn
	{
		display:inline-block;
		width:36px;
		height: 36px;
		border-radius: 50%;
		border: 1px solid #ccc;
	}
	.actions-menu
	{
		display:block!important;		
	}
	
	.filter-item
	{
		display:inline-block!important;	
		line-height:40px!important;
	}
	input{border:1px solid #aaa!important}
	label {width:70px!important;text-align:right!important;}
	
	.pull-left{
		float: left !important;
		}
	@media screen and (max-width:900px) 
	{
		.priority-2{display:none;}
		
	}
	
	
</style>

<div class="card shadow mb-4">
		<div class="card-header  justify-content-between align-items-center">                               

			<h4 class="card-title">Cars</h4> 

		</div>
		
		<div class="card-body">			
			<div class="table-responsive">
				<ul class="nav nav-tabs">
					<li class="nav-item">
						<a class="nav-link active status-tab border-left-primary shadow" data-status="All" href="#">All Cars</a>
					</li>
					<li class="nav-item">
						<a class="nav-link status-tab" data-status="0" href="#">Draft</a>
					</li>
					<li class="nav-item" style="background-color: <?= (isset($new_cars) && $new_cars > 0) ? '#ffb3b3' : '' ?>">
						<a class="nav-link status-tab" data-status="1" href="#">Pending Approval</a>
					</li>
					<li class="nav-item">
						<a class="nav-link status-tab" data-status="3" href="#">Published</a>
					</li>
					<li class="nav-item">
						<a class="nav-link status-tab" data-status="11" href="#">In Transaction</a>
					</li>
					<li class="nav-item">
						<a class="nav-link status-tab" data-status="-1" href="#">Publish Rejected</a>
					</li>
				</ul>
				<table class="table table-sm  small" id="dataTableLarge"  "paging"="false" width="99%" cellspacing="0">
					<thead>
						<tr>
							<th>Seller</th>
							<th>Car code</th>
							<th>Date created</th>
							<th>Status</th>
							<th>Brand</th>
							<th>Model class</th>
							<th>Img</th>
							<th>Edit</th>
							
						</tr>
					</thead>
					
					<tbody id="cars-table">
						<?php
						if(isset($cars)){ 
							$i=0;
							foreach ($cars as $items): 
							//var_dump($items[]);exit;
							switch ($items['status'])
							{
								case 0: $sta="Draft";break;
								case 1: $sta="Pending approval";break;
								case 3: $sta="Published";break;
								case -1: $sta="Publish rejected";break;
							}
								
						?>
						
						<tr>
							<td><?php echo $items['companyname']; ?></td>
							<td><?php echo $items['code']; ?></td>
							<td><?php echo $items['created_at']; ?></td>
							<td><?php echo $sta; ?></td>  	
							<td><?php echo $items['brand']; ?></td>
							<td><?php echo $items['model']; ?></td>
							<th><img style="width:80px" src="https://cars.zadio.bg/uploads/cars_img/<?=$items['img']?>"></th>
							<td><a href="<?php echo site_url('cars/edit/'.$items['code']);?>"  title="Edit" class="btn btn-outline-success btn-sm"><i class="fas fa-fw fa-edit"></i></a></td>
							
							
						</tr>
						<?php $i++ ?>
							
					<?php endforeach; ?>
					<?php }?>
					
					</tbody>
				</table>
			</div>
		</div>

<script>

	// Call the dataTables jQuery plugin
	$(document).ready(function() {
		
		
		$('#dataTableLarge').DataTable({pageLength: 50,
		layout: {
			top: 'info',
			topStart: 'search',
			topEnd: 'info'
		}
		
		});
		
		
		
		//Move the search box
		var rows = $('#dataTableLarge_wrapper').children('.row');
		row0=rows[0];
		var kids1 = row0.children;
		var len = kids1.length;
		
		if(len>1)
		{
			kids1[0].style.display = "none";
		}
		
		$('#dataTableLarge_filter').addClass('pull-left');
		$('#dataTableLarge_filter input').css('width', '260px');
		$('#dataTableLarge_filter').css('margin-top', '5px');
				($("#dataTableLarge_filter").parent()).append( "<div style='float:right;'><?php echo count($cars);?> items</div>");
		
	
				document.querySelectorAll('.status-tab').forEach(tab => {
			tab.addEventListener('click', function (e) {
				e.preventDefault();
				
				// Remove active class from all tabs
				document.querySelectorAll('.status-tab').forEach(link => link.classList.remove('active','border-left-primary','shadow'));
				
				// Add active class to the clicked tab
				this.classList.add('active', 'border-left-primary', 'shadow');
				
				// Get the status from the data attribute
				const status = this.getAttribute('data-status');
				
				// Fetch Cars for the selected status
				fetchCars(status);
			});
		});	
	});

	function fetchCars(status) {
		$.ajax({
			url: `cars/getcars/${status}`,
			method: 'GET',
			contentType: 'application/json',
			success: function (data) {
				const carsTable = document.getElementById('cars-table');
				carsTable.innerHTML = ''; // Clear existing rows

				// Destroy the existing DataTable instance
				if ($.fn.DataTable.isDataTable('#dataTableLarge')) {
					$('#dataTableLarge').DataTable().clear().destroy();
				}

				// Append new rows to the table
				data.cars.forEach(car => {
					let row = `
					<tr style="${getRowStyle(car)}">
						<td>${car.companyname}</td>
						<td>${car.code}</td>
						<td>${car.created_at}</td>
						<td>${getStatus(car.status)}</td>  	
						<td>${car.brand}</td>
						<td >${car.model}</td> 
						<th><img style="width:80px" src="https://cars.zadio.bg/uploads/cars_img/${car.img}"></th>
						<td><a href="cars/edit/${car.code}"  title="Edit" class="btn btn-outline-success btn-sm"><i class="fas fa-fw fa-edit"></i></a></td>
						
					</tr>
					`;
					carsTable.innerHTML += row;
				});

				// Reinitialize the DataTable
				$('#dataTableLarge').DataTable({
					paging: false,
					layout: {
						top: 'info',
						topStart: 'search',
						topEnd: 'info',
					},
				});

				// Move the search box again
				const rows = $('#dataTableLarge_wrapper').children('.row');
				if (rows.length > 0 && rows[0].children.length > 1) {
					rows[0].children[0].style.display = 'none';
				}

				$('#dataTableLarge_filter').addClass('pull-left');
				$('#dataTableLarge_filter input').css('width', '260px');
				$('#dataTableLarge_filter').css('margin-top', '5px');
				$('#dataTableLarge_filter')
					.parent()
					.append(`<div style='float:right;'>${data.count} randuri</div>`);
			},
			error: function (xhr, status, error) {
				console.error('Error fetching cars:', error);
			},
		});
	}

	function getRowStyle(car) {
		var style = "";
		if (car.status == 1) style= "color:#FF0000";
		return style;
	}

	function getStatus(status_code) {
		const statuses = {
			0: 'Draft',
			1: 'Pending approval',
			3: 'Published',
			11: 'In transaction',
			'-1': 'Publish rejected',
		};
		
		return statuses[status_code] || 'Unknown';
	}
</script>
<?= $this->endsection(); ?>