<?php $this->include('rs/utils.php') ?>
<?= $this->extend('rs/template-admin'); ?>

<?= $this->section('content'); ?>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success">
        <?= session()->getFlashdata('success') ?>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger">
        <?= session()->getFlashdata('error') ?>
    </div>
<?php endif; ?>

<style>
    .form-control {
        border: 1px solid #aaa !important;
    }
    .btn {
        margin: 5px;
    }
</style>

<div class="card shadow mb-4">
    <div class="card-header justify-content-between align-items-center">
        <h4 class="card-title"><?= $edit ? 'Edit car model class' : 'Add New car model class' ?></h4>
    </div>
    <div class="card-body">
        <form action="<?= site_url('/models/edit/' . ($car_model ? $car_model['id'] : '0')); ?>" method="post">
            <input type="hidden" name="id" value="<?= $car_model ? $car_model['id'] : '' ?>">

            <div class="form-group">
                <label for="brand">Brand</label>
                <select class="form-control" id="brand" name="brand">
                    <option value="">Select a Brand</option>
                    <?php foreach ($brands as $brand): ?>
                        <option value="<?= $brand['brand_name']; ?>" <?= old('brand', $car_model ? $car_model['brand'] : '') == $brand['brand_name'] ? 'selected' : ''; ?>>
                            <?= $brand['brand_name']; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="model_name">Model class name</label>
                <input type="text" class="form-control" id="model_name" name="model_name" value="<?= old('model_name', $car_model ? $car_model['model_name'] : ''); ?>" required>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary"><?= $edit ? 'Update Model' : 'Add Model' ?></button>
                <a href="<?= site_url('/models'); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

<script type="text/javascript">
    document.getElementById("models").classList.add("active");
</script>

<?= $this->endsection(); ?>
