<?php $this->include('rs/utils.php') ?>
<?= $this->extend('rs/template-admin'); ?>

<?= $this->section('content'); ?>


<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success">
        <?= session()->getFlashdata('success') ?>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger">
        <?= session()->getFlashdata('error') ?>
    </div>
<?php endif; ?>

<style>
    
    .form-control {
        border: 1px solid #aaa !important;
    }
    .btn {
        margin: 5px;
    }
</style>

<div class="card shadow mb-4">
    <div class="card-header justify-content-between align-items-center">
        <h4 class="card-title"><?= $edit ? 'Edit Brand' : 'Add New Brand' ?></h4>
    </div>
    <div class="card-body">
        <form action="<?= site_url('/brands/edit/' . ($brand ? $brand['id'] : '0')); ?>" method="post">
            <div class="form-group">
                <label for="brand_name">Brand Name</label>
                <input type="text" class="form-control" id="brand_name" name="brand_name" value="<?= old('brand_name', $brand ? $brand['brand_name'] : ''); ?>" required>
            </div>
            <div class="form-group">
                <button type="submit" class="btn btn-primary"><?= $edit ? 'Update Brand' : 'Add Brand' ?></button>
                <a href="<?= site_url('/brands'); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>


<script type="text/javascript">
            document.getElementById("brands").classList.add("active");
</script>


<?= $this->endsection(); ?>
