<?php $this->include('rs/utils.php')?>
<?= $this->extend('rs/template-admin'); ?>

<?= $this->section('content'); ?>

<style>
    .icon-btn {
        display: inline-block;
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: 1px solid #ccc;
    }
    .actions-menu {
        display: block!important;		
    }
    .filter-item {
        display: inline-block!important;	
        line-height: 40px!important;
    }
    input {
        border: 1px solid #aaa!important;
    }
    label {
        width: 70px!important;
        text-align: right!important;
    }
    .pull-left {
        float: left !important;
    }
    @media screen and (max-width: 900px) {
        .priority-2 { display: none; }
    }
</style>

<div class="card shadow mb-4">
    <div class="card-header justify-content-between align-items-center">                               
        <h4 class="card-title">Car Brands</h4> 
        <a href="<?= site_url('/brands/edit/0'); ?>" class="btn btn-outline-success btn-sm" title="Add New Brand">
            <i class="fas fa-fw fa-plus"></i> Add New Brand
        <a>
    </div>
    <div class="card-body">
        <table class="table table-sm small" id="dataTableLarge" "paging"="false" width="99%" cellspacing="0">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Brand Name</th>
                    <th>Edit</th>
                </tr>
            </thead>
            <tbody>
                <?php if(isset($brands)){ 
                    $i=0;
                    
                    foreach($brands as $brand) {
                        
                        ?>
                        <tr>
                            <td><?php echo $brand['id']; ?></td>
                            <td><?php echo $brand['brand_name']; ?></td>
                            <td class="priority-2"><a href="<?php echo site_url('/brands/edit/'.$brand['id']);?>"  title="Edit" class="btn btn-outline-success btn-sm"><i class="fas fa-fw fa-edit"></i></a></td>

                        </tr>
                        <?php $i++ ?>
                    <?php } 
                }?>
            </tbody>
        </table>

        <script type="text/javascript">
            $(document).ready(function() {
                $('#dataTableLarge').DataTable({
                    paging: false,
                    layout: {
                        top: 'info',
                        topStart: 'search',
                        topEnd: 'info'
                    }
                });

                //Move the search box
                var rows = $('#dataTableLarge_wrapper').children('.row');
                var row0 = rows[0];
                var kids1 = row0.children;
                var len = kids1.length;

                if (len > 1) {
                    kids1[0].style.display = "none";
                }

                $('#dataTableLarge_filter').addClass('pull-left');
                $('#dataTableLarge_filter input').css('width', '260px');
                $('#dataTableLarge_filter').css('margin-top', '5px');
                ($("#dataTableLarge_filter").parent()).append("<div style='float:right;'><?php echo count($brands);?> rows</div>");
            });

            function popup(url) {
                window.location.href = url;
                //newwindow=window.open(url,'quicktransfer','popup=1,height=300,width=450,directories=no,titlebar=no,toolbar=no,location=no,status=no,menubar=no,scrollbars=no,resizable=no,top=100,left=100,resizable = no');
                //if (window.focus) {newwindow.focus()}
                return false;
            }

            function _______popup(url) {
                newwindow = window.open(url, 'quicktransfer', 'popup=1,height=300,width=450,directories=no,titlebar=no,toolbar=no,location=no,status=no,menubar=no,scrollbars=no,resizable=no,top=100,left=100,resizable = no');
                if (window.focus) { newwindow.focus() }
                return false;
            }
        </script>

        <script type="text/javascript">
            document.getElementById("brands").classList.add("active");
            
        </script>

    </div>
<?= $this->endsection(); ?>
