<?php $this->include('rs/utils.php')?>
<?= $this->extend('rs/template-user'); ?>
<?= $this->section('content'); ?>

<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />

<link rel = "stylesheet" type = "text/css" 
   href = "<?php echo base_url(); ?>css/dashboard.css">



<script src="https://code.jquery.com/jquery-3.6.0.js"></script>

  
	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<h4 class="m-0 font-weight-bold text-primary">Dashboard</h4>
		</div>
		<div class="card-body">
					
			<div class="container">
				<!-- Cars Section -->
				<h3 class="fw-bold text-uppercase text-primary border-bottom pb-2 mb-4">Cars</h3>
				<div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
					<div class="col">

						<div class="card radius-10 border-start border-0 border-3 border-info dashboard-item" style="height: 100px;">
							<a href="/cars">
								<div class="card-body">
									<div class="d-flex align-items-center">
										<div>
											<p class="mb-0 text-secondary">Unpublished</p>
											<h4 class="my-1 text-info car-count" id="cars-draft">0</h4>
										</div>
										<div class="widgets-icons-2 rounded-circle bg-gradient-scooter text-white ms-auto">
											<i class="fa fa-car"></i>
										</div>
									</div>
								</div>
							</a>
						</div>

					</div>
					<div class="col">
						<div class="card radius-10 border-start border-0 border-3 border-success dashboard-item" style="height: 100px;">
							<a href="/cars">
								<div class="card-body">
									<div class="d-flex align-items-center">
										<div>
											<p class="mb-0 text-secondary">Published</p>
											<h4 class="my-1 text-success car-count" id="cars-published">0</h4>
										</div>
										<div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
											<i class="fa fa-car"></i>
										</div>
									</div>
								</div>
							</a>
						</div>
					</div>
					<div class="col">
						<div class="card radius-10 border-start border-0 border-3 border-warning dashboard-item" style="height: 100px;">
							<a href="/cars">
								<div class="card-body">
									<div class="d-flex align-items-center">
										<div>
											<p class="mb-0 text-secondary">In Transaction</p>
											<h4 class="my-1 text-warning car-count" id="cars-in-transaction">0</h4>
										</div>
										<div class="widgets-icons-2 rounded-circle bg-gradient-blooker text-white ms-auto">
											<i class="fa fa-exchange"></i>
										</div>
									</div>
								</div>
							</a>
						</div>
					</div>
					<div class="col">
						<div class="card radius-10 border-start border-0 border-3 border-success dashboard-item" style="height: 100px;">
							<a href="/cars">
								<div class="card-body">
									<div class="d-flex align-items-center">
										<div>
											<p class="mb-0 text-secondary">Sold</p>
											<h4 class="my-1 text-success car-count" id="cars-sold">0</h4>
										</div>
										<div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
											<i class="fa fa-check"></i>
										</div>
									</div>
								</div>
							</a>
						</div>
					</div>
				</div>

				<!-- Transactions Section -->
				<h3 class="fw-bold text-uppercase text-primary border-bottom pb-2 mt-4 mb-4">Transactions</h3>
				<div class="row row-cols-1 row-cols-md-2">
					<div class="col">
						<div class="card radius-10 border-start border-0 border-3 border-info dashboard-item" style="height: 100px;">
							<a href="/transactions">
								<div class="card-body">
									<div class="d-flex align-items-center">
										<div>
											<p class="mb-0 text-secondary">In Progress</p>
											<h4 class="my-1 text-info transaction-count" id="transactions-in-progress">0</h4>
										</div>
										<div class="widgets-icons-2 rounded-circle bg-gradient-scooter text-white ms-auto">
											<i class="fa fa-spinner"></i>
										</div>
									</div>
								</div>
							</a>
						</div>
					</div>
					<div class="col">
						<div class="card radius-10 border-start border-0 border-3 border-success dashboard-item" style="height: 100px;">
							<a href="/transactions">
								<div class="card-body">
									<div class="d-flex align-items-center">
										<div>
											<p class="mb-0 text-secondary">Finalized</p>
											<h4 class="my-1 text-success transaction-count" id="transactions-finalized">0</h4>
										</div>
										<div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
											<i class="fa fa-check-circle"></i>
										</div>
									</div>
								</div>
							</a>
						</div>
					</div>
				</div>

				<!-- Messages Section -->
				<h3 class="fw-bold text-uppercase text-primary border-bottom pb-2 mt-4 mb-4">Messages</h3>
				<div class="row">
					<div class="col">
						<div class="card radius-10 border-start border-0 border-3 border-warning dashboard-item" style="height: 100px;" id="messages-card">
							<a href="/messages">
								<div class="card-body">
									<div class="d-flex align-items-center">
										<div>
											<p class="mb-0 text-secondary">Unread Messages</p>
											<h4 class="my-1 text-warning" id="unread-messages">0</h4>
										</div>
										<div class="widgets-icons-2 rounded-circle bg-gradient-blooker text-white ms-auto">
											<i class="fa fa-envelope"></i>
										</div>
									</div>
								</div>
							</a>
						</div>
					</div>
				</div>
			</div>	
			
		</div>
	</div>

			
<script>
	function updateDashboard() {
		$.ajax({
			url: '/dashboard/getSummaries',
			method: 'GET',
			success: function(response) {
				// Cars
				const carStatusMap = {
					0: 'draft',
					1: 'pending',
					3: 'published',
					11: 'in-transaction',
					12: 'sold',
					'-1': 'rejected'
				};
				
				// Reset all counts first
				$('.car-count').text('0');
				$('.transaction-count').text('0');
				
				// Update car counts
				response.cars_count_by_status.forEach(item => {
					$(`#cars-${carStatusMap[item.status]}`).text(item.cnt);
				});

				// Update transaction counts
				response.transactions_count_by_status.forEach(item => {
					let inProgressCount = 0;
					response.transactions_count_by_status.forEach(item => {
					if(item.status == 19) {
						$('#transactions-finalized').text(item.cnt);
					} else {
						inProgressCount += parseInt(item.cnt);
					}
					});
					$('#transactions-in-progress').text(inProgressCount);
				});

				// Update unread messages
				$('#unread-messages').text(response.unread_messages_count);
				if (response.unread_messages_count > 0) {
					$('#messages-card').addClass('pulse-animation');
				} else {
					$('#messages-card').removeClass('pulse-animation');
				}
			},
			error: function() {
				console.error('Failed to fetch dashboard data');
			}
		});
	}

	// Update on load
	$(document).ready(function() {
		updateDashboard();
	});
</script>
		

<?= $this->endsection(); ?>
