<?php namespace App\Controllers;
use App\Models\SettingsModel;

class SettingsController extends BaseController
{
   public function index()
   {
	    $session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		$data = ['data' => ''];
        $us = session()->get('id');
		$data = [];

		$data['data']='';
		echo view('settings/index');
		
   }
   
   public function company()
   {
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		
		$data = [];
		$data = ['data' => ''];
		helper(['form']);
		$model = new SettingsModel();
		
		$session = session();
		$company = ($model->getCompanyData())[0];
		//var_dump($company);exit;
		if ($this->request->getMethod() == 'POST') {
			$rules = [
				'company_name' => 'required|min_length[1]|max_length[50]',
				];

			
			if (! $this->validate($rules)) {
				$data['validation'] = $this->validator;
			}else{
				$newData = [
					'id' =>1,
					'company_name' => $this->request->getPost('company_name'),
					'vat_code' => $this->request->getPost('vat_code'),
					'address1' => $this->request->getPost('address1'),
					'address2' => $this->request->getPost('address2'),
					'phone' => $this->request->getPost('phone'),
					'email' => $this->request->getPost('email'),
					'website' => $this->request->getPost('website'),
					'commission_abs' => $this->request->getPost('commission_abs'),
					'commission_percent' => $this->request->getPost('commission_percent')/100,
					'commission_min' => $this->request->getPost('commission_min'),
					'commission_abs_deal' => $this->request->getPost('commission_abs_deal'),
					'commission_percent_deal' => $this->request->getPost('commission_percent_deal')/100,
					'commission_min_deal' => $this->request->getPost('commission_min_deal'),
					'commission_type'=> $this->request->getPost('coms'),
					'commission_type_deal'=> $this->request->getPost('comsd'),
				];
				//var_dump($newData);exit;
					
					
				if($model->save($newData))
				{
					session()->setFlashdata('success', 'Company data successfuly updated');
				}
				return redirect()->to('/settings');
			}
		}
		$data['company'] = $company;
		//var_dump($data['company']);exit;
		return view('settings/company', $data);
		
   }
   
   public function contacts()
   {
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		
		$data = ['data' => ''];
        $us = session()->get('id');
		$data = [];

		$data['data']='';
		echo view('settings/index');
		
   }
   
   
   public function brands()
   {
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		$model = new SettingsModel();
		$brands = $model->get_brands();
		$data['brands'] = $brands;

		return view('settings/brands/index', $data);
		
   }

   public function editbrand($id = 0)
   {
	$session = session();
	$usr = session()->get('id');
	if (!$usr>0) 
	{
	 $this->response->redirect(site_url('/login'));
	  exit;
	}
	 
	 $data = [];
     $data = ['data' => ''];
     $session = session();
     $usr = $session->get('id');
 
     if (!$usr) {
         return redirect()->to('/login');
     }
 
     $model = new SettingsModel();
     $data['edit'] = false;
     $data['title'] = "Edit Brand";
     $data['brand'] = null;
     $data['title'] = "Edit Brand";
     
     if ($id>0) {
         $brand = $model->getBrandById($id);
 
         
 
         $data['brand'] = $brand;
         $data['edit'] = true;
         
     }
     if ($this->request->getMethod() == 'POST') 
     {
         
         $newData = [
                     'brand_name' => $this->request->getPost('brand_name')
                     ];
                     
         if($id>0){
             $res=$model->updateBrand($id,$newData);
             $message = 'Brand successfully updated'; 
         }else{
             $res=$model->insertBrand($newData);
             $message = 'Brand successfully added'; 
        }
         
         if($res)
         {
            session()->setFlashdata('success', $message); 
             return redirect()->to('/brands');
         }
         else
             return view('settings/brands/edit', $data);
         
     }	
     else
          return view('settings/brands/edit', $data);
     
 
    
 }
    public function exchangeRates()
    {
        $session = session();
        $usr = session()->get('id');
        if (!$usr>0) 
        {
        $this->response->redirect(site_url('/login'));
            exit;
        }
        $model = new SettingsModel();
        $rates = $model->get_exchange_rates();
        $data['rates'] = $rates;

        return view('settings/exchange_rates/index', $data);
        
    }

    public function editExchangeRate($id = 0)
    {
     $session = session();
     $usr = session()->get('id');
     if (!$usr>0) 
     {
      $this->response->redirect(site_url('/login'));
       exit;
     }
      
      $data = [];
      $data = ['data' => ''];
      $session = session();
      $usr = $session->get('id');
  
      if (!$usr) {
          return redirect()->to('/login');
      }
  
      $model = new SettingsModel();
      $data['edit'] = false;
      $data['title'] = "Edit Exchange Rate";
      $data['rate'] = null;
 
      
      if ($id>0) {
          $rate = $model->getRateById($id);
  
          
  
          $data['rate'] = $rate;
          $data['edit'] = true;
          
      }
      if ($this->request->getMethod() == 'POST') 
      {
          
          $newData = [
                    'from_currency' => $this->request->getPost('from_currency'),
                    'to_currency' => $this->request->getPost('to_currency'),
                    'exchange_rate' => $this->request->getPost('exchange_rate')
                      ];
                      
          if($id>0){
              $res=$model->updateExchangeRate($id,$newData);
              $message = 'Exchange rate successfully updated'; 
          }else{
              $res=$model->insertExchangeRate($newData);
              $message = 'Exchange rate successfully added'; 
         }
          
          if($res)
          {
             session()->setFlashdata('success', $message); 
              return redirect()->to('/exchangerates');
          }
          else
              return view('settings/exchange_rates/edit', $data);
          
      }	
      else
           return view('settings/exchange_rates/edit', $data);
      
  
     
  }
 
   
   public function models()
   {
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		
		$model = new SettingsModel;
		$car_models = $model->get_models();
		$data['car_models'] = $car_models;
		return view('settings/models/index',$data);
		
   }


   public function editModel($id = 0)
{
	
	$session = session();
	$usr = session()->get('id');
	if (!$usr>0) 
	{
	 $this->response->redirect(site_url('/login'));
	  exit;
	}
    $data = [];
    $data = ['data' => ''];
    $session = session();
    $usr = $session->get('id');

    
    if (!$usr) {
        return redirect()->to('/login');
    }

    $model = new SettingsModel();
    $data['edit'] = false;  
    $data['title'] = "Add New Car Model";
    $data['car_model'] = null;  
    $data['brands'] = $model->get_brands(); 

    
    if ($id > 0) {
        $car_model = $model->get_model_by_id($id);


        $data['car_model'] = $car_model; 
        $data['edit'] = true;  
        $data['title'] = "Edit Car Model";
    }

    
    if ($this->request->getMethod() == 'POST') {
        $newData = [
            'model_name' => $this->request->getPost('model_name'),
            'brand' => $this->request->getPost('brand'),
        ];

        if ($id > 0) {
           
            $res = $model->update_model($id, $newData);  
            $message = 'Model successfully updated';  
        } else {
            $res = $model->insert_model($newData);  
            $message = 'Model successfully added';
        }

        if($res)
         {
            session()->setFlashdata('success', $message); 
             return redirect()->to('/models');
         }
         else
             return view('settings/models/edit', $data);
         
    }else{
        return view('settings/models/edit', $data);
    }
    
}

   public function countries()
   {
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		
		$model = new SettingsModel;
		$countries = $model->get_country();
		$data['countries'] = $countries;
		return view('settings/countries/index',$data);
   }
   

   public function editCountries($id = 0)
   {
     
	 $session = session();
	  $usr = session()->get('id');
	 if (!$usr>0) 
	{
	 $this->response->redirect(site_url('/login'));
	  exit;
	}
	 $data = [];
     $data = ['data' => ''];
     $session = session();
     $usr = $session->get('id');
 
     if (!$usr) {
         return redirect()->to('/login');
     }
 
     $model = new SettingsModel();
     $data['edit'] = false;
     $data['title'] = "Edit Country";
     $data['country'] = null;
     $data['title'] = "Edit Country";
     
     if ($id>0) {
         $country = $model->get_country_by_id($id);
 
         
 
         $data['country'] = $country;
         $data['edit'] = true;
         
     }
     if ($this->request->getMethod() == 'POST') 
     {
         
         $newData = [
                     'country_name' => $this->request->getPost('country_name')
                     ];
                     
         if($id>0){
             $res=$model->update_country($id,$newData);
             $message = 'Country successfully updated';
         }else{
             $res=$model->insert_country($newData);
             $message = 'Country successfully added';
         }
         
         if($res)
         {
            session()->setFlashdata('success', $message); 
             return redirect()->to('/countries');
         }
         else
             return view('settings/countries/edit', $data);
         
     }	
     else
          return view('settings/countries/edit', $data);
     
 
    
 }

   

 public function editCarsAdditionals($id = 1)
 {
     
	 $session = session();
		$usr = session()->get('id');
		if (!$usr>0) 
		{
		 $this->response->redirect(site_url('/login'));
		  exit;
		}
		
	 $data = [];
     $data['title'] = "Edit Cars Additionals";
     $session = session();
     $usr = $session->get('id');

     
     if (!$usr) {
         return redirect()->to('/login');
     }

     $model = new SettingsModel();
     $data['edit'] = false;
     $data['additionals'] = null;

     
     if ($id > 0) {
         $additionals = $model->get_additionals_by_id($id);

         
         if ($additionals) {
             $data['additionals'] = $additionals;
             $data['edit'] = true;
         } else {
             return redirect()->to('/settings')->with('error', 'Data not found');
         }
     }

     
     if ($this->request->getMethod() == 'POST') {
         $newData = [
             'json' => $this->request->getPost('json_data') 
         ];

         if ($id > 0) {
             $res = $model->update_additionals($id, $newData);
             $message = 'Data successfully updated';
         }

         if ($res) {
             session()->setFlashdata('success', $message);
             return redirect()->to('/settings'); 
         } else {
             return view('settings/cars_additionals', $data); 
         }
     } else {
         return view('settings/cars_additionals', $data); 
     }
 }

 public function editPublicCookies($id = 1)
 {
    $session = session();
    $usr = session()->get('id');
    if (!$usr>0) 
    {
     $this->response->redirect(site_url('/login'));
      exit;
    }
    
    $data = [];
    $data['title'] = "Edit Public Cookies";
    $session = session();
    $usr = $session->get('id');

    
    if (!$usr) {
        return redirect()->to('/login');
    }

    $model = new SettingsModel();
    $data['edit'] = false;
    $data['additionals'] = null;
 

    if ($id > 0) {
        $additionals = $model->get_public_cookies_by_id($id);

        
        if ($additionals) {
            $data['additionals'] = $additionals;
            $data['edit'] = true;
        } else {
            return redirect()->to('/settings')->with('error', 'Data not found');
        }
    }

    if ($this->request->getMethod() == 'POST') {
        $newData = [
            'public_cookies' => $this->request->getPost('public_cookies_data') 
        ];

        if ($id > 0) {
            $res = $model->update_public_cookies($id, $newData);
            $message = 'Data successfully updated';
        }

        if ($res) {
            session()->setFlashdata('success', $message);
            return redirect()->to('/settings'); 
        } else {
            return view('settings/public_cookies', $data); 
        }
    } else {
        return view('settings/public_cookies', $data); 
    }
 }

 public function editPublicTerms($id = 1)
 {
    $session = session();
    $usr = session()->get('id');
    if (!$usr>0) 
    {
     $this->response->redirect(site_url('/login'));
      exit;
    }
    
    $data = [];
    $data['title'] = "Edit Public Terms";
    $session = session();
    $usr = $session->get('id');

    
    if (!$usr) {
        return redirect()->to('/login');
    }

    $model = new SettingsModel();
    $data['edit'] = false;
    $data['additionals'] = null;
 

    if ($id > 0) {
        $additionals = $model->get_public_terms_by_id($id);

        
        if ($additionals) {
            $data['additionals'] = $additionals;
            $data['edit'] = true;
        } else {
            return redirect()->to('/settings')->with('error', 'Data not found');
        }
    }

    if ($this->request->getMethod() == 'POST') {
        $newData = [
            'public_terms' => $this->request->getPost('public_terms_data') 
        ];

        if ($id > 0) {
            $res = $model->update_public_terms($id, $newData);
            $message = 'Data successfully updated';
        }

        if ($res) {
            session()->setFlashdata('success', $message);
            return redirect()->to('/settings'); 
        } else {
            return view('settings/public_terms', $data); 
        }
    } else {
        return view('settings/public_terms', $data); 
    }
 }


 public function editCommercialTermsSellers($id = 1)
 {
    $session = session();
    $usr = session()->get('id');
    if (!$usr>0) 
    {
     $this->response->redirect(site_url('/login'));
      exit;
    }
    
    $data = [];
    $data['title'] = "Edit Commercial Terms and Conditions for Sellers";
    $session = session();
    $usr = $session->get('id');

    
    if (!$usr) {
        return redirect()->to('/login');
    }

    $model = new SettingsModel();
    $data['edit'] = false;
    $data['additionals'] = null;
 

    if ($id > 0) {
        $additionals = $model->get_commercial_terms_sellers_by_id($id);

        
        if ($additionals) {
            $data['additionals'] = $additionals;
            $data['edit'] = true;
        } else {
            return redirect()->to('/settings')->with('error', 'Data not found');
        }
    }

    if ($this->request->getMethod() == 'POST') {
        $newData = [
            'ctcs' => $this->request->getPost('ctcs_data') 
        ];

        if ($id > 0) {
            $res = $model->update_commercial_terms_sellers($id, $newData);
            $message = 'Data successfully updated';
        }

        if ($res) {
            session()->setFlashdata('success', $message);
            return redirect()->to('/settings'); 
        } else {
            return view('settings/commercial_terms_sellers', $data); 
        }
    } else {
        return view('settings/commercial_terms_sellers', $data); 
    }
 }




 public function editCommercialTermsBuyers($id = 1)
 {
    $session = session();
    $usr = session()->get('id');
    if (!$usr>0) 
    {
     $this->response->redirect(site_url('/login'));
      exit;
    }
    
    $data = [];
    $data['title'] = "Edit Commercial Terms and Conditions for Buyers";
    $session = session();
    $usr = $session->get('id');

    
    if (!$usr) {
        return redirect()->to('/login');
    }

    $model = new SettingsModel();
    $data['edit'] = false;
    $data['additionals'] = null;
 

    if ($id > 0) {
        $additionals = $model->get_commercial_terms_buyers_by_id($id);

        
        if ($additionals) {
            $data['additionals'] = $additionals;
            $data['edit'] = true;
        } else {
            return redirect()->to('/settings')->with('error', 'Data not found');
        }
    }

    if ($this->request->getMethod() == 'POST') {
        $newData = [
            'ctcb' => $this->request->getPost('ctcb_data') 
        ];

        if ($id > 0) {
            $res = $model->update_commercial_terms_buyers($id, $newData);
            $message = 'Data successfully updated';
        }

        if ($res) {
            session()->setFlashdata('success', $message);
            return redirect()->to('/settings'); 
        } else {
            return view('settings/commercial_terms_buyers', $data); 
        }
    } else {
        return view('settings/commercial_terms_buyers', $data); 
    }
 }


 public function editExchangeRates(){
    return view('settings/exchange_rates');
 }


}
