<?php

namespace App\Models;

use CodeIgniter\Model;

class FavoritesModel extends Model
{
    protected $table = 'favorites'; // Name of the database table
    protected $primaryKey = 'id'; // Primary key of the table
    protected $allowedFields = ['user_id', 'car_id', 'added_on']; // Fields that can be inserted/updated

    /**
     * Check if a car is already a favorite for the given user.
     *
     * @param int $userId
     * @param int $carId
     * @return bool
     */
    public function isFavorite($userId, $carId)
    {
        return $this->where('user_id', $userId)
                    ->where('car_id', $carId)
                    ->countAllResults() > 0;
    }

    /**
     * Add a car to the user's favorites.
     *
     * @param int $userId
     * @param int $carId
     * @return bool
     */
    public function addFavorite($userId, $carId)
    {
        return $this->insert([
            'user_id' => $userId,
            'car_id' => $carId,
            'added_on' => date('Y-m-d H:i:s')
        ]);
    }

    /**
     * Remove a car from the user's favorites.
     *
     * @param int $userId
     * @param int $carId
     * @return bool
     */
    public function removeFavorite($userId, $carId)
    {
        return $this->where('user_id', $userId)
                    ->where('car_id', $carId)
                    ->delete();
    }

    /**
     * Get all favorite cars for a user.
     *
     * @param int $userId
     * @return array
     */
    public function getFavoritesByUser($userId)
    {
        return $this->select('cars.*') // Assuming you have a `cars` table to join with
                    ->join('cars', 'favorites.car_id = cars.id')
                    ->where('favorites.user_id', $userId)
                    ->findAll();
    }
}
