<?php namespace Config;
$routes = Services::routes(true);
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}
$routes->setDefaultNamespace('App\Controllers');
//$routes->setDefaultController('Users');

$routes->setDefaultController('Main');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override('\App\Controllers\MainController::index');
$routes->setAutoRoute(true);

$routes->match(['get','post'],'/cookiespolicy'   , 'CookiesPolicy::index');

$routes->match(['get','post'],'/'                		 	, 'MainController::index');
$routes->get('get-quick-options', 'MainController::getQuickOptions');
$routes->match(['get','post'],'/CAR(:segment)/(:segment)'	, 'MainController::cardetails/CAR$1/$2');
$routes->match(['get','post'],'/galery/(:segment)'		, 'MainController::galery/$1');
$routes->match(['get','post'],'/brandmodels'    		, 'MainController::brandmodels');
$routes->match(['get','post'],'fueltypes'				, 'MainController::fueltypes');
$routes->post('favorites/toggle'						, 'MainController::toggleFavorite');


$routes->get('/contact' , 'ContactController::index');

$routes->match(['get','post'],'/login'       	, 'Users::login');
$routes->match(['get','post'], '/register'   	, 'Users::register');
$routes->match(['get','post'], '/confirmreg' 	, 'Users::confirmreg');
$routes->get ('logout'                     	 	, 'Users::logout');
$routes->match(['get','post'],'/profile'     	, 'Users::profile'                      		,['filter' => 'auth']);
$routes->match(['get','post'],'/changepwd'     	, 'Users::changepwd'                    		,['filter' => 'auth']);


$routes->get ('dashboard'                  		, 'DashboardController::index'           		,['filter' => 'auth']);
$routes->get ('dashboard/search'           		, 'DashboardController::search'          		,['filter' => 'auth']);
$routes->post('dashboard/search'           		, 'DashboardController::search'          		,['filter' => 'auth']);
$routes->get ('dashboard/list'             		, 'DashboardController::list'            		,['filter' => 'auth']);
$routes->post('dashboard/list'             		, 'DashboardController::list'            		,['filter' => 'auth']);
$routes->get ('dashboard/getSummaries'			, 'DashboardController::get_summaries'			, ['filter' => 'auth']);


$routes->match(['get','post'],'cars'            		, 'CarsController::index'           	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/edit/(:any)'  		, 'CarsController::edit/$1'           	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/additionals/(:any)' , 'CarsController::additionals/$1'     ,['filter' => 'auth']);
$routes->match(['get','post'],'cars/cardetails/(:any)'  , 'CarsController::cardetails/$1'       ,['filter' => 'auth']);
$routes->match(['get','post'],'cars/remove/(:segment)'  , 'CarsController::remove/$1'           ,['filter' => 'auth']);


$routes->match(['get','post'],'cars/uploadimg/(:any)'  	, 'CarsController::uploadimg/$1'        ,['filter' => 'auth']);
$routes->post('cars/delimg/(:any)'  	, 'CarsController::delimg/$1'        					,['filter' => 'auth']);

$routes->match(['get','post'],'cars/brandmodels' 		, 'CarsController::brandmodels'     	,['filter' => 'auth']);
$routes->match(['get','post'],'users/countrydistricts/(:segment)' 	, 'Users::countrydistricts/$1');
$routes->match(['get','post'],'transactions' 			, 'TransactionsController::index/$1', 					['filter' => 'auth']);
$routes->match(['get','post'],'/buycar/(:segment)/(:segment)' , 'TransactionsController::create/$1/$2'	,		['filter' => 'auth']);
$routes->match(['get','post'],'transactions/detail/(:segment)', 'TransactionsController::detail/$1', 	['filter' => 'auth']);
$routes->match(['get','post'],'/transactions/savestep/(:segment)' , 'TransactionsController::savestep/$1'		,['filter' => 'auth']);
$routes->match(['get','post'],'/searches' , 'SearchController::index'		,['filter' => 'auth']);

// $routes->match(['get','post'],'/messages' , 'MessagesController::index'		,['filter' => 'auth']);
$routes->get('/messages', 'MessagesController::index', ['filter' => 'auth']);
$routes->post('/messages/sendMessage', 'MessagesController::sendMessage', ['filter' => 'auth']);
$routes->get('/messages/getMessages', 'MessagesController::getMessages', ['filter' => 'auth']);


$routes->match(['get','post'],'/favorites' , 'FavoritesController::index'		,['filter' => 'auth']);
$routes->match(['get','post'],'/statistics' , 'StatisticsController::index'		,['filter' => 'auth']);
$routes->match(['get','post'],'/zadioinfo' , 'ZadioController::index'		,['filter' => 'auth']);



if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
