<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UserModel;
use App\Models\TransactionModel;
define("TRAN_PATH", "/home/zadio/cars.zadio.bg/zadio/public/uploads/transactions");
define("TRAN_VPATH", "https://cars.zadio.bg/uploads/transactions/");

class TransactionsController extends BaseController
{
	
	public function create($carcode,$model_dec)
	{
		$data = ['data' => ''];
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		$usr = session()->get('id');
		$transactionModel = new TransactionModel();
		$transactionModel->create($carcode,$usr);
		echo view('transactions/detail', $data);
	}
	
	public function index()
	{
		
		$data = ['data' => ''];
		
		//var_dump("index");exit;
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	      $this->response->redirect(site_url('/login'));
		  exit;
        }
		
		$transactionModel = new TransactionModel();
		$trans=$transactionModel->getAll();
		$data['transactions']=$trans;
		if ($this->request->getMethod()== 'POST')
		{
			//set filters
		
        }
		//var_dump($data['transactions']);
		echo view('transactions/index', $data);
       
    }
	
	public function detail($code)
	{
		$data = ['data' => ''];
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }

		$transactionModel = new TransactionModel();
		
		$trans=$transactionModel->getTransaction($code);
		$transHist=$transactionModel->getHist($code);
		$data['transaction']=$trans;
		$data['transHist']=$transHist;
		//var_dump($transaction);exit;
		echo view('transactions/detail', $data);
	}
	
	public function savestep()
	{
		$data = ['data' => ''];
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }

		if ($this->request->getMethod()== 'POST')
		{
			$transactionModel = new TransactionModel();
			$history_id=$this->request->getVar('history_id');
			
			$trans=$transactionModel->getHistoryById($history_id);
			//var_dump($trans);	exit;
			
			$trans_code=$trans['transaction_code'];
			$step=$trans['step'];
			
			$chk1=$this->request->getVar('chk1');
			$chk2=$this->request->getVar('chk2');
			$chk3=$this->request->getVar('chk3');
			$notes=$this->request->getVar('chk_notes');
			//Make dir
			$dirfile=TRAN_PATH.'/'.$trans_code;
			if (!file_exists($dirfile)) {
				mkdir($dirfile, 0777, true);
			}
			$i=0;
			foreach($_FILES as $file)
			{
				
				$date=date('dmyGis');
				$new_file_name=$date.$file["name"];
				$traget_path=$dirfile."/".$file["name"];
				$short_path= $trans_code."/".$file["name"];
				if(move_uploaded_file($file['tmp_name'], $dirfile."/".$file["name"]))
				{
					$attach[$i]=$short_path;
					$i++;
					
				}
				else
				{
					$retval=  array('error'=>'Upload fail');
					echo json_encode($retval);
					exit;
				}
			
			}
			
			//save data
			$db = db_connect();
			
			$sqlstr="update transaction_history set ";
			if($chk1)
				$sqlstr.="chk1=1 , ";
			if($chk2)
				$sqlstr.="chk2=1 , ";
			if($chk3)
				$sqlstr.="chk3=1 , ";
			if($chk3)
				$sqlstr.="chk3=1 , ";
			if($notes)
				$sqlstr.="chk_notes='$notes',";
			if(isset($attach[0]))
					$sqlstr.="attach_1='".$attach[0]."',";
			if(isset($attach[1]))
					$sqlstr.="attach_2='".$attach[1]."',";
			if(isset($attach[2]))
					$sqlstr.="attach_3='".$attach[2]."',";
				
			
			$sqlstr.="completed=1,completed_at=NOW() ";	
			$sqlstr.= " WHERE id=".$history_id;
			//var_dump($sqlstr);exit;
            $db->query($sqlstr);

			
			$newstep=$step+1;
			$sqlstr="insert into transaction_history (transaction_code,step) values('$trans_code',$newstep)";
			$db->query($sqlstr);
			
			$sqlstr="update  transaction set trans_step=$newstep where trans_code='$trans_code'";
			$db->query($sqlstr);
			
			
			
        }
		$transactionModel = new TransactionModel();
		$trans=$transactionModel->getTransaction($trans_code);
		$transHist=$transactionModel->getHist($trans_code);
		$data['transaction']=$trans;
		$data['transHist']=$transHist;
		//var_dump($transaction);exit;
		echo view('transactions/detail', $data);
	}
		
    
	
}
