<?php
namespace App\Models;
use CodeIgniter\Model;
Class SettingsModel extends Model {
    protected $db;
	protected $table = 'company_details';
	protected $allowedFields = ['company_name','vat_code','address1','address2', 'email','phone', 'website'];


	 public function __construct()
    {
        $this->db = db_connect();

        
    }
	
	public function getCompanyData() {
        $query = $this->db->query("SELECT * FROM company_details");
        return $query->getResult('array');
    }
	
    public function get_all($usr) {
        $query = $this->db->query("SELECT * FROM cars where client_id=$usr");
        return $query->getResult('array');
    }
    
	
   
  
    public function get_by_id($id,$usr) {
        $query = $this->db->query("SELECT * FROM cars where id=$id and client_id=$usr");
        return $query->getResult('array');
    }
	
	 public function get_by_code($code,$usr) {
        $query = $this->db->query("SELECT * FROM cars where code='$code' and client_id=$usr");
        return $query->getResult('array');
    }


	 public function get_imgs($code) {
        $query = $this->db->query("SELECT * FROM `car_images` where car_code='$code'");
        return $query->getResult('array');
    }


	public function get_brands() {
        $query = $this->db->query("SELECT distinct id, brand_name FROM car_brand  where active=1 order by brand_name");
        return $query->getResult('array');
    }
	
	public function getBrandById($id) {
        $query = $this->db->query("SELECT * FROM car_brand WHERE id = ?", [$id]);
        return $query->getRowArray(); 
    }
    

    public function updateBrand($id, $data) {
        if (empty($id) || !is_array($data) || !isset($data['brand_name'])) {
            return false;
        }
    
        $builder = $this->db->table('car_brand');
        $builder->where('id', $id);
        return $builder->update($data);

    }

    public function insertBrand($data) {
        if (!is_array($data) || !isset($data['brand_name'])) {
            return false;
        }
    
        $builder = $this->db->table('car_brand');
        return $builder->insert($data);
    }
    
	
	
    public function get_models() {
        $query = $this->db->query("SELECT id, brand, model_name FROM car_model WHERE active = 1 ORDER BY brand, model_name");
        return $query->getResult('array');
    }
	
	

	public function get_client_brands($usr) {
        $query = $this->db->query("SELECT distinct brand as brand_name FROM cars where client_id=$usr order by brand_name" );
        return $query->getResult('array');
    }
	
	
	public function get_country() {
        $query = $this->db->query("SELECT distinct id, country_name FROM country order by country_name");
        return $query->getResult('array');
    }
	
	public function get_car_status() {
        $query = $this->db->query("SELECT distinct id, status_name FROM car_status where active=1 order by status_name ");
        return $query->getResult('array');
    }
	
	
	
    public function set_values($id = 1) {
        $data = array(
            'quantity_defect' => $this->input->post('quantity_defect')
        );
		
        if ($id !=0) {        
           $obs=$this->input->post('obs');
			$quantity_defect=$this->input->post('quantity_defect');
			
			$sqlstr="update cars set quantity_defect=quantity_defect+".$quantity_defect." where id=" . $id;
			$this->db->query($sqlstr);
			
			$sqlstr="insert into defect_log(product_id,quantity_defect,obs) values(".$id.",".$quantity_defect.",'".$obs."')";
			return $this->db->query($sqlstr);
			
		
        } 
    }
    
    public function search(){
        $this->db->or_like('description', $this->input->post('search'), 'both');
        $this->db->or_like('barcode', $this->input->post('search'), 'both');
        $this->db->or_like('customer', $this->input->post('search'), 'both');
		$this->db->where('quantity_defect>0');
        $query = $this->db->get('products');
        return $query->getResult('array');
    }
    
    
    
}
