<?php namespace App\Controllers;
use App\Models\SettingsModel;

class SettingsController extends BaseController
{
   public function index()
   {
		$data = ['data' => ''];
        $us = session()->get('id');
		$data = [];

		$data['data']='';
		echo view('settings/index');
		
   }
   
   public function company()
   {
		$data = [];
		$data = ['data' => ''];
		helper(['form']);
		$model = new SettingsModel();
		
		$session = session();
		$company = ($model->getCompanyData())[0];
		
		if ($this->request->getMethod() == 'POST') {
			$rules = [
				'company_name' => 'required|min_length[1]|max_length[50]',
				];

			
			if (! $this->validate($rules)) {
				$data['validation'] = $this->validator;
			}else{
				$newData = [
					'id' =>1,
					'company_name' => $this->request->getPost('company_name'),
					'vat_code' => $this->request->getPost('vat_code'),
					'address1' => $this->request->getPost('address1'),
					'address2' => $this->request->getPost('address2'),
					'phone' => $this->request->getPost('phone'),
					'email' => $this->request->getPost('email'),
					'website' => $this->request->getPost('website'),
					];
					
				if($model->save($newData))
				{
					session()->setFlashdata('success', 'Company data successfuly updated');
				}
				return redirect()->to('/settings');
			}
		}
		$data['company'] = $company;
		//var_dump($data['company']);exit;
		return view('settings/company', $data);
		
   }
   
   public function contacts()
   {
		$data = ['data' => ''];
        $us = session()->get('id');
		$data = [];

		$data['data']='';
		echo view('settings/index');
		
   }
   
   
   public function brands()
   {
		
		$model = new SettingsModel();
		$brands = $model->get_brands();
		$data['brands'] = $brands;

		return view('settings/brands/index', $data);
		
   }
   
   
  public function editbrand($id = 0)
  {
    $data = [];
	$data = ['data' => ''];
    $session = session();
    $usr = $session->get('id');

    if (!$usr) {
        return redirect()->to('/login');
    }

    $model = new SettingsModel();
    $data['edit'] = false;
    $data['title'] = "Edit Brand";
    $data['brand'] = null;
	$data['title'] = "Edit Brand";
	
    if ($id>0) {
        $brand = $model->getBrandById($id);

        

        $data['brand'] = $brand;
        $data['edit'] = true;
        
    }
	if ($this->request->getMethod() == 'POST') 
	{
		
		$newData = [
					'brand_name' => $this->request->getPost('brand_name')
					];
					
		if($id>0)
			$res=$model->updateBrand($id,$newData);
		else
			$res=$model->insertBrand($newData);
		
		if($res)
		{
			session()->setFlashdata('success', 'Brand data successfuly updated');
			return redirect()->to('/brands');
		}
		else
			return view('settings/brands/edit', $data);
		
	}	
	else
		 return view('settings/brands/edit', $data);
	

   
}

   
   public function models()
   {
		$model = new SettingsModel;
		$car_models = $model->get_models();
		$data['car_models'] = $car_models;
		return view('settings/models/index',$data);
		
   }
   
   public function countries()
   {
		$model = new SettingsModel;
		$countries = $model->get_country();
		$data['countries'] = $countries;
		return view('settings/countries/index',$data);
   }
   
  
}
