<?php namespace Config;
$routes = Services::routes(true);
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}
$routes->setDefaultNamespace('App\Controllers');
//$routes->setDefaultController('Users');

$routes->setDefaultController('Main');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

$routes->match(['get','post'],'/'                	, 'Users::login');
$routes->match(['get','post'],'/userlist'     	 	, 'Users::userlist' ,['filter' => 'auth']);
$routes->match(['get','post'],'/getusers/(:any)'     	 	, 'Users::getUsersByRole/$1' ,['filter' => 'auth']);
$routes->match(['get','post'],'/edituser/(:any)'  	, 'Users::edituser/$1' ,['filter' => 'auth']);
$routes->match(['get','post'],'/user/viewuser/(:any)'  , 'Users::viewuser/$1' ,['filter' => 'auth']);


$routes->match(['get','post'],'/brandmodels'     , 'MainController::brandmodels'     		);



$routes->match(['get','post'],'/login'       	, 'Users::login'                        );
$routes->match(['get','post'], '/register'   	, 'Users::register'       			   	 );
$routes->match(['get','post'], '/confirmreg' 	, 'Users::confirmreg'       			);
$routes->get ('logout'                     	 	, 'Users::logout');
$routes->match(['get','post'],'/profile'     	, 'Users::profile'                      ,['filter' => 'auth']);
$routes->match(['get','post'],'/changepwd'     	, 'Users::changepwd'                    ,['filter' => 'auth']);


$routes->get ('dashboard'                  		, 'DashboardController::index'           ,['filter' => 'auth']);
$routes->get ('dashboard/search'           		, 'DashboardController::search'          ,['filter' => 'auth']);
$routes->post('dashboard/search'           		, 'DashboardController::search'          ,['filter' => 'auth']);
$routes->get ('dashboard/list'             		, 'DashboardController::list'            ,['filter' => 'auth']);
$routes->post('dashboard/list'             		, 'DashboardController::list'            ,['filter' => 'auth']);
$routes->get ('dashboard/testMail'			, 'DashboardController::testMail'			 ,['filter' => 'auth']);

$routes->match(['get','post'],'cars'            		, 'CarsController::index'           	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/edit/(:any)'  		, 'CarsController::edit/$1'           	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/uploadimg/(:any)'  	, 'CarsController::uploadimg/$1'        ,['filter' => 'auth']);
$routes->match(['get','post'],'cars/brandmodels' 		, 'CarsController::brandmodels'     	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/getcars/(:any)' 	, 'CarsController::getCarsByStatus/$1'     	,['filter' => 'auth']);
$routes->match(['get','post'],'settings'            	, 'SettingsController::index'           ,['filter' => 'auth']);
$routes->match(['get','post'],'cars/cardetails/(:any)'  , 'CarsController::cardetails/$1'       ,['filter' => 'auth']);



$routes->match(['get','post'],'company'         	    , 'SettingsController::company'           	,['filter' => 'auth']);
$routes->match(['get','post'],'contacts'         	    , 'SettingsController::contacts'          ,['filter' => 'auth']);
$routes->match(['get','post'],'editcontact/(:any)'      , 'SettingsController::editcontact/$1'   ,['filter' => 'auth']);

$routes->match(['get','post'],'brands'             		, 'SettingsController::brands'      	,['filter' => 'auth']);
$routes->match(['get','post'],'brands/edit/(:any)'      , 'SettingsController::editbrand/$1'      	,['filter' => 'auth']);


$routes->match(['get','post'],'models'             		, 'SettingsController::models'      	,['filter' => 'auth']);
$routes->match(['get','post'],'models/edit/(:any)'      , 'SettingsController::editmodel/$1'     ,['filter' => 'auth']);

$routes->match(['get','post'],'countries'             	, 'SettingsController::countries'      	,['filter' => 'auth']);
$routes->match(['get','post'],'countries/edit/(:any)'   , 'SettingsController::editCountries/$1'      	,['filter' => 'auth']);

$routes->match(['get','post'],'exchangerates'             	, 'SettingsController::exchangeRates'      	,['filter' => 'auth']);
$routes->match(['get','post'],'exchangerates/edit/(:any)'   , 'SettingsController::editExchangeRate/$1'      	,['filter' => 'auth']);


$routes->match(['get','post'],'cars_additionals/(:any)'   , 'SettingsController::editCarsAdditionals/$1'    ,['filter' => 'auth']);


$routes->match(['get','post'],'public_cookies/(:any)'   , 'SettingsController::editPublicCookies/$1'    ,['filter' => 'auth']);
$routes->match(['get','post'],'public_terms/(:any)'     , 'SettingsController::editPublicTerms/$1'    ,['filter' => 'auth']);

$routes->match(['get','post'],'commercial_terms_sellers/(:any)'     , 'SettingsController::editCommercialTermsSellers/$1'    ,['filter' => 'auth']);
$routes->match(['get','post'],'commercial_terms_buyers/(:any)'      , 'SettingsController::editCommercialTermsBuyers/$1'    ,['filter' => 'auth']);

$routes->match(['get','post'],'exchange_rates'     , 'SettingsController::editExchangeRates'    ,['filter' => 'auth']);

$routes->match(['get','post'],'transactions' 			, 'TransactionsController::index/$1'	,['filter' => 'auth']);
$routes->match(['get','post'],'/transactions/detail/(:segment)' , 'TransactionsController::detail/$1'	,['filter' => 'auth']);
$routes->match(['get','post'],'/transactions/savestep' , 'TransactionsController::savestep'		,['filter' => 'auth']);


$routes->get('/messages', 'MessagesController::index', ['filter' => 'auth']);
$routes->post('/messages/sendMessage', 'MessagesController::sendMessage', ['filter' => 'auth']);
$routes->get('/messages/getMessages', 'MessagesController::getMessages', ['filter' => 'auth']);
$routes->get('/messages/(:num)/', 'MessagesController::index/$1', ['filter' => 'auth']);
$routes->get('/messages/newThread/(:any)', 'MessagesController::createNewThread/$1', ['filter' => 'auth']);

$routes->match(['get','post'],'/buycar/(:segment)/(:segment)' 	, 'TransactionsController::create/$1/$2'	,['filter' => 'auth']);

$routes->match(['get'], '/CookiesPolicy'				 , 'MainController::CookiesPolicy'		);

if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
