<?php
// Check if the required parameters are present
if (isset($_GET['url']) && isset($_GET['width'])) {
    $url = urldecode($_GET['url']); // Decode the URL-encoded image path
    $newWidth = intval($_GET['width']); // Ensure the width is an integer

    // Fetch the original image
    $imageInfo = getimagesize($url);
    if ($imageInfo === false) {
        die("Invalid image.");
    }

    // Get original image dimensions
    list($originalWidth, $originalHeight) = $imageInfo;

    // Calculate the new height to maintain aspect ratio
    $newHeight = intval(($newWidth / $originalWidth) * $originalHeight);

    // Create a new blank image with the new dimensions
    $resizedImage = imagecreatetruecolor($newWidth, $newHeight);

    // Load the original image based on its mime type
    switch ($imageInfo['mime']) {
        case 'image/jpeg':
            $sourceImage = imagecreatefromjpeg($url);
            break;
        case 'image/png':
            $sourceImage = imagecreatefrompng($url);
            break;
        case 'image/gif':
            $sourceImage = imagecreatefromgif($url);
            break;
        default:
            die("Unsupported image format.");
    }

    // Resize the image
    imagecopyresampled($resizedImage, $sourceImage, 0, 0, 0, 0, $newWidth, $newHeight, $originalWidth, $originalHeight);

    // Set the correct content type for the output image
    header("Content-Type: " . $imageInfo['mime']);

    // Output the resized image based on its mime type
    switch ($imageInfo['mime']) {
        case 'image/jpeg':
            imagejpeg($resizedImage);
            break;
        case 'image/png':
            imagepng($resizedImage);
            break;
        case 'image/gif':
            imagegif($resizedImage);
            break;
    }

    // Free up memory
    imagedestroy($resizedImage);
    imagedestroy($sourceImage);
} else {
    die("Missing parameters.");
}