<?php

const VATBG="0.20";
const BGNEUR="0.51129";

function front_url()
{
	return "https://cars.zadio.bg/";
}

$vatbg=0.20;
$bgneur=0.51129;
$roneur=0.20;

load_commissions();

function formatPhone($number)
{
	if(strlen($number) >= 10) {
	  if(substr($number,0,1)=='+')
	  {
		  $prefix=substr($number,0,4);
		  $number=substr($number,4);
		  $parts = str_split($number, 3);
		  $number = $prefix.' '. $parts[0] .' '. $parts[1] .' '. $parts[2];
	  }
	}
	return $number;
}

function formatCode($number)
{
	  //$parts = str_split($number, 3);
	  //$number = $parts[0] .'.'. $parts[1] .'.'. $parts[2].'.'. $parts[3];
	  return $number;
}

function seller_bgnBrut($priceBGN)
{
	return round($priceBGN*(1+VATBG));
}

function seller_eurNet($priceBGN) //fara tva
{
	return round($priceBGN*BGNEUR);
}

function seller_eurBrut($priceBGN) //fara tva
{
	return round($priceBGN*BGNEUR*(1+VATBG));
	
}

function load_commissions()
{
	//var_dump(session()->get('commission_abs'));exit;
	
	if(session()->get('commission_abs')==NULL)
	{
		$sqlstr="select  `commission_abs`, `commission_percent`, `commission_min`,`commission_abs_deal`, `commission_percent_deal`, `commission_min_deal` from company_details limit 1";
		$db = db_connect();
		$query = $db->query($sqlstr);
		$res= $query->getResult('array');
		foreach($res as $row)
		{
			session()->set($row);
			//var_dump(session()->get());exit;
			return;
		}
	}
	
}


function bgnNet($priceBGN) //fara tva
{
	return round($priceBGN*(1+VATBG));
}


function buy_eurNet($priceBGN) //fara tva
{
	$session = session();
	
	if(session()->get('seller')==1)
	{
		$commission_abs=0;
		$commission_percent=0;
		$commission_min=0;
	}
	else
	{
		if(session()->get('buyer')==1)
		{
			$commission_abs=$session->get('commission_abs_deal');
			$commission_percent=$session->get('commission_percent_deal');
			$commission_min=$session->get('commission_min_deal');
		}
	
		else //not seller, not buyer
		{
			$commission_abs=$session->get('commission_abs');
			$commission_percent=$session->get('commission_percent');
			$commission_min=$session->get('commission_minl');
		}
	}
		
	if($commission_abs>0)
		return round(($priceBGN+$commission_abs)*BGNEUR,2);
	else
	{
		if($priceBGN*$commission_percent > $commission_min)
			return round($priceBGN*BGNEUR*(1+$commission_percent),2);
		else
			return round(($priceBGN+$commission_min)*BGNEUR,2);
	}
}
function _sale_eurNet($priceBGN)
{
	if(session()->get('commission_abs_sale')>0)
		return buy_eurNet($priceBGN)+session()->get('commission_abs_sale');
	else
	{
		if(session()->get('commission_min_sale')> (1+session()->get('commission_percent_sale'))*buy_eurNet($priceBGN))
			return buy_eurNet($priceBGN)+session()->get('commission_min_sale');
		else
			return (1+session()->get('commission_percent_sale'))*buy_eurNet($priceBGN);
	}
}

function buy_eurBrut($priceBGN) //fara tva
{
	return round(buy_eurNet($priceBGN)*(1+VATBG),2);
}



function sale_eurNet($priceBGN) //fara tva
{
	$session = session();
	$commission_abs=$session->get('commission_abs_deal');
	$commission_percent=$session->get('commission_percent_deal');
	$commission_min=$session->get('commission_min_deal');
	$priceEUR=seller_eurNet($priceBGN);
	
	if($commission_abs>0)
		return round($priceEUR+$commission_abs);
	else
	{
		if($commission_abs*$commission_percent > $commission_min)
			return round($priceEUR*(1+$commission_percent),2);
		else
			return round($priceEUR +$commission_min,2);
	}
	
}

function sale_eurBrut($priceBGN) //fara tva
{
	return round(buyer_eurNet($priceBGN)*(1+VATBG),2);
}



?>