<?php $this->include('rs/utils.php') ?>
<?= $this->extend('rs/template-admin'); ?>

<?= $this->section('content'); ?>


<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success">
        <?= session()->getFlashdata('success') ?>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger">
        <?= session()->getFlashdata('error') ?>
    </div>
<?php endif; ?>

<style>
    
    .form-control {
        border: 1px solid #aaa !important;
    }
    .btn {
        margin: 5px;
    }
</style>

<div class="card shadow mb-4">
    <div class="card-header justify-content-between align-items-center">
        <h4 class="card-title"><?= $edit ? 'Edit Exchange Rate' : 'Add New Exchange Rate' ?></h4>
    </div>
    <div class="card-body">
        <form action="<?= site_url('/exchangerates/edit/' . ($rate ? $rate['id'] : '0')); ?>" method="post">
            <div class="form-group">
                <label for="from_currency">From Currency</label>
                <input type="text" class="form-control" id="from_currency" name="from_currency" value="<?= old('from_currency', $rate ? $rate['from_currency'] : ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="to_currency">To Currency</label>
                <input type="text" class="form-control" id="to_currency" name="to_currency" value="<?= old('to_currency', $rate ? $rate['to_currency'] : ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="exchange_rate">Exchange Rate</label>
                <input type="text" class="form-control" id="exchange_rate" name="exchange_rate" value="<?= old('exchange_rate', $rate ? $rate['exchange_rate'] : ''); ?>" required>
            </div>
            <div class="form-group">
                <button type="submit" class="btn btn-primary"><?= $edit ? 'Update Exchange Rate' : 'Add Exchange Rate' ?></button>
                <a href="<?= site_url('/exchangerates'); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>


<script type="text/javascript">
            document.getElementById("exchange_bar").classList.add("active");
</script>


<?= $this->endsection(); ?>
